// testforocxDlg.cpp : implementation file
//

#include "stdafx.h"
#include "testforocx.h"
#include "testforocxDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
//#define  WM_RECEDATA     WM_USER+1000

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestforocxDlg dialog

CTestforocxDlg::CTestforocxDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestforocxDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestforocxDlg)
	m_Address = 0;
	m_Baud = 0;
	m_OutputState = FALSE;
	m_PcControl = FALSE;
	m_Port = 0;
	m_PowMax = 0;
	m_VolMax = 0;
	m_VolSet = 0;
	m_CurMax = 0;
	m_Rece = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestforocxDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestforocxDlg)
	DDX_Control(pDX, IDC_RECE_LIST, m_ReceList);
	DDX_Control(pDX, IDC_PSSERVER1, m_PsServer);
	DDX_Text(pDX, IDC_ADDRESS, m_Address);
	DDX_Text(pDX, IDC_BAUD, m_Baud);
	DDX_Check(pDX, IDC_OUTPUT_STATE, m_OutputState);
	DDX_Check(pDX, IDC_PCCONTROL, m_PcControl);
	DDX_Text(pDX, IDC_PORT, m_Port);
	DDX_Text(pDX, IDC_POWMAX, m_PowMax);
	DDX_Text(pDX, IDC_VOLMAX, m_VolMax);
	DDX_Text(pDX, IDC_VOLSET, m_VolSet);
	DDX_Text(pDX, IDC_CURMAX, m_CurMax);
	DDX_LBString(pDX, IDC_RECE_LIST, m_Rece);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestforocxDlg, CDialog)
	//{{AFX_MSG_MAP(CTestforocxDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OpenComm, OnOpenComm)
	ON_BN_CLICKED(IDC_CloseComm, OnCloseComm)
	ON_BN_CLICKED(IDC_StateControl, OnStateControl)
	ON_BN_CLICKED(IDC_Setting, OnSetting)
	ON_BN_CLICKED(IDC_Read, OnRead)	
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestforocxDlg message handlers

BOOL CTestforocxDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_Port=2;
	m_Address=0;
	m_Baud=9600;
	m_PcControl=TRUE;
	m_OutputState=TRUE;
	m_VolMax=36;
	m_CurMax=3;
    m_PowMax=108;
	m_VolSet=20;
	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestforocxDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestforocxDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestforocxDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//Open COM
void CTestforocxDlg::OnOpenComm() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_PsServer.PS_OpenComm(m_Port,m_Baud,8,0,0);
	m_PsServer.PS_SetDeviceAdd(m_Address);
	
}

//Close COM
void CTestforocxDlg::OnCloseComm() 
{
	// TODO: Add your control notification handler code here
	m_PsServer.PS_CloseComm();
}

//Control Power State
void CTestforocxDlg::OnStateControl() 
{
	// TODO: Add your control notification handler code here
	int State;
	State=0;
	UpdateData(TRUE);
	if (m_PcControl) 
	{
       if (m_OutputState)
		   State=3;
	   else 
		   State=2;
	}
	m_PsServer.PS_ControlState(State);
}

//Setting Power Params
void CTestforocxDlg::OnSetting() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_PsServer.PS_SetParams(m_CurMax*1000,m_VolMax*1000,
		m_PowMax*100,m_VolSet*1000,m_Address);
    
	
}

//Read Power Params
void CTestforocxDlg::OnRead() 
{
	// TODO: Add your control notification handler code here
	m_PsServer.PS_ReadParams();
}


//Receive data event
BEGIN_EVENTSINK_MAP(CTestforocxDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CTestforocxDlg)
	ON_EVENT(CTestforocxDlg, IDC_PSSERVER1, 4 /* OnReceive */, OnReceivePsserver1, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

//Receive data event procedure
void CTestforocxDlg::OnReceivePsserver1() 
{
	// TODO: Add your control notification handler code here
	long CurValue,CurMax,VolValue,
	     VolSetting,VolMax,PowValue,PowMax,State;
	m_PsServer.PS_GetData(&CurValue,&CurMax,&VolValue,&VolSetting,
		&VolMax,&PowValue,&PowMax,&State);
    m_ReceList.AddString("--------- Read Params ----------- ");
	m_Rece.Format("CurValue(mA) :%d CurMax(mA) :%d",CurValue,CurMax);
	m_ReceList.AddString(m_Rece);
    m_Rece.Format("VolValue(mV) :%d VolSet(mV) :%d VolMax(mV) :%d",VolValue,VolSetting,VolMax);
	m_ReceList.AddString(m_Rece);
    m_Rece.Format("PowValue(mV) :%d PowMax(mV) :%d",PowValue,PowMax);
	m_ReceList.AddString(m_Rece);
	m_Rece.Format("State :%d",State);
	m_ReceList.AddString(m_Rece);
	if (State &  1 == 1 )
      m_Rece="Output State : On";
	else
	  m_Rece="Output State : Off";
    m_ReceList.AddString(m_Rece);
	if (State &  2 == 2 )
      m_Rece="Current Alarm State : Exceptional";
	else
	  m_Rece="Current Alarm State : Normal";
    m_ReceList.AddString(m_Rece);
	if (State &  4 == 4 )
      m_Rece="Power Alarm State : Exceptional";
	else
	  m_Rece="Power Alarm State : Normal";
    m_ReceList.AddString(m_Rece);
    if (State &  8 == 8 )
      m_Rece="Control State : PC";
	else
	  m_Rece="Control State : Self";
    m_ReceList.AddString(m_Rece);
	UpdateData(TRUE);
}

void CTestforocxDlg::OnAbout() 
{
	// TODO: Add your control notification handler code here
	m_PsServer.PS_ShowAbout();	
}
